/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import vectorwing.farmersdelight.common.block.FeastBlock;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class ExpendBlock
extends FeastBlock {
    public final int servingItemAmount;

    public ExpendBlock(BlockBehaviour.Properties properties, Supplier<Item> servingItem, boolean hasLeftovers, int servingItemAmount) {
        super(properties, servingItem, hasLeftovers);
        this.servingItemAmount = servingItemAmount;
    }

    protected InteractionResult takeServing(LevelAccessor level, BlockPos pos, BlockState state, Player player, InteractionHand hand) {
        int servings = (Integer)state.m_61143_((Property)this.getServingsProperty());
        if (servings == 0) {
            level.m_5594_(null, pos, SoundEvents.f_12630_, SoundSource.PLAYERS, 0.8f, 0.8f);
            level.m_46961_(pos, true);
            return InteractionResult.SUCCESS;
        }
        ItemStack serving = this.getServingItem(state);
        ItemStack heldStack = player.m_21120_(hand);
        if (servings > 0) {
            if (!serving.hasCraftingRemainingItem() || ItemStack.m_41656_((ItemStack)heldStack, (ItemStack)serving.getCraftingRemainingItem())) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getServingsProperty(), (Comparable)Integer.valueOf(servings - 1)), 3);
                if (!player.m_150110_().f_35937_ && serving.hasCraftingRemainingItem()) {
                    heldStack.m_41774_(1);
                }
                if (!player.m_150109_().m_36054_(serving)) {
                    for (int i = 0; i < this.servingItemAmount; ++i) {
                        player.m_36176_(serving, false);
                    }
                }
                if ((Integer)level.m_8055_(pos).m_61143_((Property)this.getServingsProperty()) == 0 && !this.hasLeftovers) {
                    level.m_7471_(pos, false);
                }
                level.m_5594_(null, pos, SoundEvents.f_11675_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            player.m_5661_((Component)TextUtils.getTranslation((String)"block.feast.use_container", (Object[])new Object[]{serving.getCraftingRemainingItem().m_41786_()}), true);
        }
        return InteractionResult.PASS;
    }
}

